{{-- resources/views/peninjauan/index.blade.php --}}
@extends('admin-layouts.master')

@section('title', 'Daftar Peninjauan Lapangan')

@section('content')

<div class="row">
    <div class="col-12">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="h4 mb-1">Daftar Peninjauan Lapangan</h2>
                <p class="text-muted mb-0">Kelola dan pantau data peninjauan lapangan dengan mudah</p>
            </div>
            {{-- <a href="{{ route('peninjauan.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Tambah Peninjauan
            </a> --}}
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Peninjauan</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $peninjauanList->total() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Selesai</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $peninjauanList->where('status', 'selesai')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Menunggu</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $peninjauanList->whereIn('status', ['draft'])->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Ditolak</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">
                                    {{ $peninjauanList->where('status', 'belum selesai')->count() }}
                                </div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter & Search -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
            </div>
            <div class="card-body">
                <form method="GET" action="{{ route('peninjauan.index') }}" class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control form-control-sm"
                                   id="search" name="search"
                                   placeholder="Nomor BA, Nama Pemilik, atau Lokasi"
                                   value="{{ request('search') }}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control form-control-sm" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                                <option value="belum selesai" {{ request('status') == 'belum selesai' ? 'selected' : '' }}>Belum Selesai</option>
                                <option value="selesai" {{ request('status') == 'selesai' ? 'selected' : '' }}>Selesai</option>

                            </select>
                        </div>
                    </div>

                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="year">Tahun</label>
                            <select class="form-control form-control-sm" id="year" name="year">
                                <option value="">Semua Tahun</option>
                                @for($year = date('Y'); $year >= 2020; $year--)
                                    <option value="{{ $year }}" {{ request('year') == $year ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endfor
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="{{ route('peninjauan.index') }}" class="btn btn-secondary btn-sm ml-1">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Success/Error Messages -->
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
        @endif

        <!-- Data Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Data Peninjauan Lapangan</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="thead-light">
                            <tr>
                                <th width="12%">NIK Registrasi</th>
                                <th width="15%">Pemohon</th>
                                <th width="20%">Tanggal BA</th>
                                <th width="12%">Nomor BA</th>

                                <th width="10%">Status Peninjauan</th>

                                <th width="15%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($peninjauanList as $item)
                            <tr>
                                 <td>
                                    <strong class="text-primary">{{ $item->skpt->no_registrasi ?? '' }}</strong>
                                </td>
                                 <td>
                                    <div class="font-weight-bold">{{ $item->skpt->nama_pemohon ?? '-' }}</div>

                                </td>
                                 <td>
                                     <div class="font-weight-bold">{{ $item->ba_tanggal ? \Carbon\Carbon::parse($item->ba_tanggal)->format('d/m/Y') : '-' }}</div>
                                    <small></small>
                                </td>
                                <td>
                                    <strong class="text-primary">{{ $item->nomor_ba_kesaksian }}</strong>
                                </td>

                                <td>
                                    @if($item->status == 'selesai')
                                        <span class="badge badge-success">
                                            <i class="fas fa-check-circle"></i> Selesai
                                        </span>
                                    @elseif($item->status == 'verified')
                                        <span class="badge badge-info">
                                            <i class="fas fa-check"></i> Verified
                                        </span>
                                    @elseif($item->status == 'submitted')
                                        <span class="badge badge-warning">
                                            <i class="fas fa-clock"></i> Submitted
                                        </span>
                                    @elseif($item->status == 'belum selesai')
                                        <span class="badge badge-danger">
                                            <i class="fas fa-times-circle"></i> Belum Selesai
                                        </span>
                                    @else
                                        <span class="badge badge-secondary">
                                            <i class="fas fa-edit"></i> Draft
                                        </span>
                                    @endif
                                </td>

                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('peninjauan.show', $item->id) }}"
                                           class="btn btn-sm btn-outline-primary"
                                           data-toggle="tooltip" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>

                                        @if($item->status == 'draft' )
                                        <a href="{{ route('peninjauan.edit', $item->id) }}"
                                           class="btn btn-sm btn-outline-warning"
                                           data-toggle="tooltip" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endif

                                        @if($item->status == 'draft' )
                                        <button type="button"
                                                class="btn btn-sm btn-outline-danger"
                                                data-toggle="tooltip" title="Hapus"
                                                onclick="confirmDelete('{{ $item->nomor_ba_kesaksian }}', '{{ route('peninjauan.destroy', $item->id) }}')">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        @endif

                                        @if($item->status != 'selesai')
                                        <button type="button"
                                                class="btn btn-sm btn-outline-success update-status"
                                                data-toggle="tooltip" title="Tandai Selesai"
                                                data-id="{{ $item->id }}"
                                                data-status="selesai">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        @endif

                                        {{-- @if($item->status == 'submitted')
                                        <button type="button"
                                                class="btn btn-sm btn-outline-info update-status"
                                                data-toggle="tooltip" title="Verifikasi"
                                                data-id="{{ $item->id }}"
                                                data-status="selesai">
                                            <i class="fas fa-check-double"></i>
                                        </button>
                                        @endif --}}
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <h5>Tidak ada data</h5>
                                        <p>Belum ada data peninjauan lapangan yang tersedia</p>
                                        <a href="{{ route('peninjauan.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Tambah Peninjauan Pertama
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($peninjauanList->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="showing-info">
                        <small class="text-muted">
                            Menampilkan {{ $peninjauanList->firstItem() }} - {{ $peninjauanList->lastItem() }}
                            dari {{ $peninjauanList->total() }} data
                        </small>
                    </div>
                    {{ $peninjauanList->appends(request()->query())->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus data peninjauan <strong id="deleteItemName"></strong>?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan dan akan menghapus semua data terkait.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Hapus
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(itemName, deleteUrl) {
    $('#deleteItemName').text(itemName);
    $('#deleteForm').attr('action', deleteUrl);
    $('#deleteModal').modal('show');
}

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Update status peninjauan
$('.update-status').on('click', function() {
    const id = $(this).data('id');
    const status = $(this).data('status');
    const statusText = status === 'selesai' ? 'Selesai' : status === 'Belum Selesai' ? 'belum selesai' : status;

    Swal.fire({
        title: 'Konfirmasi',
        text: 'Apakah Anda yakin ingin mengubah status peninjauan menjadi ' + statusText + '?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#e74a3b',
        confirmButtonText: 'Ya',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '{{ route("peninjauan.updateStatus", ":id") }}'.replace(':id', id),
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: status
                },
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sukses!',
                        text: 'Status peninjauan berhasil diperbarui.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#1cc88a',
                    }).then(() => {
                        location.reload();
                    });
                },
                error: function(xhr) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        text: 'Gagal memperbarui status peninjauan.',
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#e74a3b',
                    });
                }
            });
        }
    });
});

// Auto-hide alerts
setTimeout(function() {
    $('.alert').each(function() {
        $(this).alert('close');
    });
}, 5000);

// Success/Error Messages
@if(session('success'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'success',
            title: 'Sukses!',
            text: '{{ session('success') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#1cc88a',
        });
    });
@endif

@if(session('error'))
    $(document).ready(function() {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: '{{ session('error') }}',
            confirmButtonText: 'OK',
            confirmButtonColor: '#e74a3b',
        });
    });
@endif
</script>
@endpush

@push('styles')
<style>
.border-left-primary {
    border-left: 0.25rem solid #4e73df !important;
}
.border-left-success {
    border-left: 0.25rem solid #1cc88a !important;
}
.border-left-info {
    border-left: 0.25rem solid #36b9cc !important;
}
.border-left-warning {
    border-left: 0.25rem solid #f6c23e !important;
}

.table-hover tbody tr:hover {
    background-color: rgba(0,0,0,.02);
}

.btn-group .btn {
    margin: 0 1px;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15) !important;
}

.text-gray-800 {
    color: #5a5c69 !important;
}

.text-gray-300 {
    color: #dddfeb !important;
}
</style>
@endpush
